#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules.FrmEnableModifications;

#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_BloodComponentClass : BaseTest 
	{

		private DataTable _dtComponentClass;
		private BOL.BloodComponentClass _testComponentClass;
		

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				string sql = " SELECT TOP 1 CC.ComponentClassId, CCP.OrderableIndicator, ComponentClassName, DivisionCode, MaximumTransfusionTime, CCP.LastUpdateUser, CCP.RowVersion" +
					" FROM ComponentClass CC " +
					" JOIN ComponentClassParameter CCP ON CC.ComponentClassId = CCP.ComponentClassId " +
					"      AND RecordStatusCode = 'A' AND DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "' ORDER by CCP.LastUpdateDate DESC";

				this._dtComponentClass = UnitTestUtil.RunSQLGetDataTable(sql, true);

				this.RefreshData = false;
			}

			this._testComponentClass = new BOL.BloodComponentClass(this._dtComponentClass.Rows[0]);
			this._testComponentClass.SetInitialBrokenRules(BROKEN.FormClassName);
		}

		[Test]
		public void Ctor_Blank_Pass()
		{
			BOL.BloodComponentClass tmpObject = new BOL.BloodComponentClass();

			Assert.IsTrue(tmpObject.BloodComponentClassId == System.Int32.MinValue);
			Assert.IsTrue(tmpObject.BloodComponentName == string.Empty);
			Assert.IsTrue(tmpObject.IsSpecimenRequired == false);
			Assert.IsTrue(tmpObject.MaximumTransfusionTime == System.Int32.MinValue);
			Assert.IsTrue(tmpObject.IsOrderable == false);
			Assert.IsTrue(tmpObject.IsDirty == false);
			Assert.IsTrue(tmpObject.IsNew == true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Blank_Fail()
		{
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			Assert.IsTrue(this._testComponentClass.BloodComponentClassId == (int)this._dtComponentClass.Rows[0][TABLES.ComponentClass.ComponentClassId]);
			Assert.IsTrue(this._testComponentClass.BloodComponentName == this._dtComponentClass.Rows[0][TABLES.ComponentClass.ComponentClassName].ToString());
			Assert.IsTrue(this._testComponentClass.IsOrderable == (bool)this._dtComponentClass.Rows[0][TABLES.ComponentClassParameter.OrderableIndicator]);
			Assert.IsTrue(this._testComponentClass.MaximumTransfusionTime == System.Convert.ToInt32(this._dtComponentClass.Rows[0][TABLES.ComponentClassParameter.MaximumTransfusionTime]));
			Assert.IsTrue(this._testComponentClass.RowVersion == (byte[])this._dtComponentClass.Rows[0][TABLES.ComponentClass.RowVersion]);
			Assert.IsTrue(this._testComponentClass.IsDirty == false);
			Assert.IsTrue(this._testComponentClass.IsNew == false);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_DataRow_Fail()
		{
		}

		[Test]
		public void BloodComponentClassId_Pass()
		{
			this._testComponentClass.BloodComponentClassId = (int)Common.ComponentClass.RBC;
			Assert.IsTrue(this._testComponentClass.BloodComponentClassId == (int)Common.ComponentClass.RBC);
			Assert.IsTrue(this._testComponentClass.IsSpecimenRequired == true);

			this._testComponentClass.BloodComponentClassId = (int)Common.ComponentClass.WB;
			Assert.IsTrue(this._testComponentClass.BloodComponentClassId == (int)Common.ComponentClass.WB);
			Assert.IsTrue(this._testComponentClass.IsSpecimenRequired == true);
		}

		[Test]
		public void BloodComponentClassId_Fail()
		{
			this._testComponentClass.BloodComponentClassId = Int32.MinValue;
			Assert.IsTrue(this._testComponentClass.IsRuleBroken(BROKEN.BloodComponentClassId));
		}

		[Test]
		public void BloodComponentClassID_Pass()
		{
			this._testComponentClass.BloodComponentClassID = (int)Common.ComponentClass.RBC;
			Assert.IsTrue(this._testComponentClass.BloodComponentClassID == (int)Common.ComponentClass.RBC);
			Assert.IsTrue(this._testComponentClass.IsSpecimenRequired == true);

			this._testComponentClass.BloodComponentClassID = (int)Common.ComponentClass.WB;
			Assert.IsTrue(this._testComponentClass.BloodComponentClassID == (int)Common.ComponentClass.WB);
			Assert.IsTrue(this._testComponentClass.IsSpecimenRequired == true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BloodComponentClassID_Fail()
		{
		}
		
		[Test]
		public void ComponentClassParameterGuid_Pass()
		{
			System.Guid tmpValue = System.Guid.NewGuid();

			this._testComponentClass.ComponentClassParameterGuid = tmpValue;

			Assert.IsTrue(this._testComponentClass.ComponentClassParameterGuid == tmpValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ComponentClassParameterGuid_Fail()
		{
		}

		[Test]
		public void BloodComponentName_Pass()
		{
			string tmpValue = System.DateTime.Now.ToString();

			this._testComponentClass.BloodComponentName = tmpValue;

			Assert.IsTrue(this._testComponentClass.BloodComponentName == tmpValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BloodComponentName_Fail()
		{
		}

		[Test]
		public void IsOrderable_Pass()
		{
			bool tmpValue = (!this._testComponentClass.IsOrderable);

			this._testComponentClass.IsOrderable = tmpValue;
			Assert.IsTrue(this._testComponentClass.IsOrderable == tmpValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsOrderable_Fail()
		{
		}

		[Test]
		public void IsSpecimenRequired_Pass()
		{
			bool tmpValue = (!this._testComponentClass.IsSpecimenRequired);

			this._testComponentClass.IsSpecimenRequired = tmpValue;
			Assert.IsTrue(this._testComponentClass.IsSpecimenRequired == tmpValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsSpecimenRequired_Fail()
		{
		}

		[Test]
		public void MaximumTransfusionTime_Pass()
		{
			int tmpValue = new Random().Next(999);

			this._testComponentClass.MaximumTransfusionTime = tmpValue;
			Assert.IsTrue(this._testComponentClass.MaximumTransfusionTime == tmpValue);
		}

		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException))]
		public void MaximumTransfusionTime_Fail()
		{
			this._testComponentClass.MaximumTransfusionTime = 1000;
		}

		[Test]
		public void GetComponentClassValues_Pass()
		{
			DataTable dt = BOL.BloodComponentClass.GetComponentClassValues();

			Assert.IsTrue(dt.Rows.Count > 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetComponentClassValues_Fail()
		{
		}

		[Test]
		public void GetComponentRequirements_Pass()
		{
			DataTable dt = BOL.BloodComponentClass.GetComponentRequirements();
			Assert.IsTrue(dt.Rows.Count > 0);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetComponentRequirements_Fail()
		{
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow dr = this._dtComponentClass.NewRow();

			dr = this._testComponentClass.LoadDataRowFromThis(dr);

			Assert.IsTrue(this._testComponentClass.BloodComponentClassId == System.Convert.ToInt32(dr[TABLES.ComponentClass.ComponentClassId]));
			Assert.IsTrue(this._testComponentClass.BloodComponentName == dr[TABLES.ComponentClass.ComponentClassName].ToString());
			Assert.IsTrue(this._testComponentClass.MaximumTransfusionTime == System.Convert.ToInt32(dr[TABLES.ComponentClassParameter.MaximumTransfusionTime]));
			Assert.IsTrue(this._testComponentClass.RowVersion == (byte[])dr[TABLES.ComponentClass.RowVersion]);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

		[Test]
		public void Clear_Pass()
		{
			this._testComponentClass.Clear();

			Assert.IsTrue(this._testComponentClass.BloodComponentClassId == System.Int32.MinValue);
			Assert.IsTrue(this._testComponentClass.BloodComponentName == string.Empty);
			Assert.IsTrue(this._testComponentClass.IsSpecimenRequired == false);
			Assert.IsTrue(this._testComponentClass.MaximumTransfusionTime == System.Int32.MinValue);
			Assert.IsTrue(this._testComponentClass.IsOrderable == false);
			Assert.IsTrue(this._testComponentClass.IsDirty == false);
			Assert.IsTrue(this._testComponentClass.IsNew == true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Clear_Fail()
		{
		}


		[Test]
		public void GetComponentClasses_Pass()
		{
			DataTable dt = this._testComponentClass.GetComponentClasses();
			Assert.AreEqual(6,dt.Rows.Count);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetComponentClasses_Fail()
		{
		}

		[Test]
		public void SaveComponentClasses_Pass()
		{
			BOL.BloodComponentClass tmpObject = new BOL.BloodComponentClass(this._dtComponentClass.Rows[0]);

			//Set up component class data table
			DataTable dtComponentClass = new DataTable();
			dtComponentClass.Columns.Add(TABLES.ComponentClassParameter.ComponentClassParameterGuid, typeof(System.Guid));
			dtComponentClass.Columns.Add(TABLES.ComponentClassParameter.DivisionCode);
			dtComponentClass.Columns.Add(TABLES.ComponentClassParameter.MaximumTransfusionTime, typeof(int));
			dtComponentClass.Columns.Add(TABLES.ComponentClassParameter.ComponentClassId, typeof(short));
			dtComponentClass.Columns.Add(TABLES.ComponentClass.ComponentClassName, typeof(string));
			dtComponentClass.Columns.Add(TABLES.ComponentClass.ComponentClassShortName, typeof(string));
			dtComponentClass.Columns.Add(TABLES.ComponentClassParameter.SpecimenRequiredIndicator, typeof(bool));
			dtComponentClass.Columns.Add(TABLES.ComponentClassParameter.OrderableIndicator, typeof(bool));
			dtComponentClass.Columns.Add(TABLES.ComponentClass.SortColumn, typeof(int));
			dtComponentClass.Columns.Add(TABLES.ComponentClassParameter.RowVersion, typeof(byte[]));
			//
			//Add in values
			DataRow drComponentClass = dtComponentClass.NewRow();
			drComponentClass[TABLES.ComponentClassParameter.ComponentClassParameterGuid] = System.Guid.NewGuid();
			drComponentClass[TABLES.ComponentClassParameter.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drComponentClass[TABLES.ComponentClassParameter.MaximumTransfusionTime]= tmpObject.MaximumTransfusionTime;
			drComponentClass[TABLES.ComponentClassParameter.ComponentClassId] = tmpObject.BloodComponentClassId;
			drComponentClass[TABLES.ComponentClassParameter.SpecimenRequiredIndicator] = tmpObject.IsSpecimenRequired;
			drComponentClass[TABLES.ComponentClassParameter.OrderableIndicator] = tmpObject.IsOrderable;
			drComponentClass[TABLES.ComponentClassParameter.RowVersion] = tmpObject.RowVersion;
			dtComponentClass.Rows.Add(drComponentClass);
			dtComponentClass.AcceptChanges();
			//
			//Now make a change so that it will be returned by GetChanges
			dtComponentClass.Rows[0][TABLES.ComponentClass.SortColumn] = 999;
			//
			//Now create an insert row
			Guid componentClassParameterGuid = Guid.NewGuid();
			DataRow drAddComponentClass = dtComponentClass.NewRow();
			drAddComponentClass.ItemArray = drComponentClass.ItemArray;
			drAddComponentClass[TABLES.ComponentClassParameter.ComponentClassParameterGuid] = componentClassParameterGuid;
			drAddComponentClass[TABLES.ComponentClassParameter.RowVersion] = DBNull.Value;
			dtComponentClass.Rows.Add(drAddComponentClass);
			//
			//Retrieve lab test data table
			BOL.LabTest labTest = new BOL.LabTest();
			labTest.ReportType = Common.ReportType.InappropriateTransfusionRequest;
			DataTable dtLabTests = labTest.GetLabTests();
			dtLabTests.AcceptChanges();
			//
			Guid specimenTestThresholdGuid = Guid.NewGuid();
			if (dtLabTests.Rows.Count>0)
			{
				//Now make a change so that it will be returned by GetChanges
				dtLabTests.Rows[0][TABLES.ComponentClass.LastUpdateUser] = Environment.UserName;
				//Add a row
				DataRow dr = dtLabTests.NewRow();
				dr.ItemArray = dtLabTests.Rows[0].ItemArray;
				dr[TABLES.SpecimenTestThreshold.SpecimenTestThresholdGuid] = specimenTestThresholdGuid;
				dr[TABLES.SpecimenTestThreshold.RowVersion] = DBNull.Value;
				dtLabTests.Rows.Add(dr);
			}
			//
			tmpObject.SaveComponentClasses(dtComponentClass, dtLabTests, Common.UpdateFunction.UnitTests);
			//
			//Now delete the inserts
			UnitTestUtil.RunSQL("DELETE FROM ComponentClassParameter WHERE ComponentClassParameterGuid = '"+componentClassParameterGuid.ToString()+"'");
			UnitTestUtil.RunSQL("DELETE FROM SpecimenTestThreshold WHERE SpecimenTestThresholdGuid = '"+specimenTestThresholdGuid.ToString()+"'");

			Assert.IsTrue(true, "ReturnValue");		//A failure will exception
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void SaveComponentClasses_Fail()
		{
			BOL.BloodComponentClass tmpObject = new BOL.BloodComponentClass(this._dtComponentClass.Rows[0]);

			//Set up component class data table
			DataTable dtComponentClass = new DataTable();
			dtComponentClass.Columns.Add(TABLES.ComponentClassParameter.ComponentClassParameterGuid, typeof(System.Guid));
			dtComponentClass.Columns.Add(TABLES.ComponentClassParameter.DivisionCode);
			dtComponentClass.Columns.Add(TABLES.ComponentClassParameter.MaximumTransfusionTime, typeof(int));
			dtComponentClass.Columns.Add(TABLES.ComponentClassParameter.ComponentClassId, typeof(short));
			dtComponentClass.Columns.Add(TABLES.ComponentClass.ComponentClassName, typeof(string));
			dtComponentClass.Columns.Add(TABLES.ComponentClass.ComponentClassShortName, typeof(string));
			dtComponentClass.Columns.Add(TABLES.ComponentClassParameter.SpecimenRequiredIndicator, typeof(bool));
			dtComponentClass.Columns.Add(TABLES.ComponentClassParameter.OrderableIndicator, typeof(bool));
			dtComponentClass.Columns.Add(TABLES.ComponentClass.SortColumn, typeof(int));
			dtComponentClass.Columns.Add(TABLES.ComponentClassParameter.RowVersion, typeof(byte[]));
			//
			//Add in values
			DataRow drComponentClass = dtComponentClass.NewRow();
			drComponentClass[TABLES.ComponentClassParameter.ComponentClassParameterGuid] = tmpObject.ComponentClassParameterGuid;
			drComponentClass[TABLES.ComponentClassParameter.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drComponentClass[TABLES.ComponentClassParameter.MaximumTransfusionTime]= tmpObject.MaximumTransfusionTime;
			drComponentClass[TABLES.ComponentClassParameter.ComponentClassId] = tmpObject.BloodComponentClassId;
			drComponentClass[TABLES.ComponentClassParameter.SpecimenRequiredIndicator] = tmpObject.IsSpecimenRequired;
			drComponentClass[TABLES.ComponentClassParameter.OrderableIndicator] = tmpObject.IsOrderable;
			drComponentClass[TABLES.ComponentClassParameter.RowVersion] = tmpObject.RowVersion;
			dtComponentClass.Rows.Add(drComponentClass);
			dtComponentClass.AcceptChanges();
			//Change the row version
			drComponentClass[TABLES.ComponentClassParameter.RowVersion] = new byte[8];
			//
			tmpObject.SaveComponentClasses(dtComponentClass, null, Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void IncludesRedBloodCells_Pass()
		{
			BOL.BloodComponentClass bcc = new BOL.BloodComponentClass();
			//
			bcc.BloodComponentClassID = (int)Common.ComponentClass.RBC;
			Assert.IsTrue(bcc.IncludesRedBloodCells);
			//
			bcc.BloodComponentClassID = (int)Common.ComponentClass.WB;
			Assert.IsTrue(bcc.IncludesRedBloodCells);
		}
		
		[Test]
		public void IncludesRedBloodCells_Fail()
		{
			BOL.BloodComponentClass bcc = new BOL.BloodComponentClass();
			//
			bcc.BloodComponentClassID = (int)Common.ComponentClass.CRYO;
			Assert.IsTrue(!bcc.IncludesRedBloodCells);
			//
			bcc.BloodComponentClassID = (int)Common.ComponentClass.FFP;
			Assert.IsTrue(!bcc.IncludesRedBloodCells);
			//
			bcc.BloodComponentClassID = (int)Common.ComponentClass.PLT;
			Assert.IsTrue(!bcc.IncludesRedBloodCells);
			//
			bcc.BloodComponentClassID = (int)Common.ComponentClass.Other;
			Assert.IsTrue(!bcc.IncludesRedBloodCells);
			//
			bcc.BloodComponentClassID = (int)Common.ComponentClass.ConversionClass;
			Assert.IsTrue(!bcc.IncludesRedBloodCells);
		}
	}
}
#endif






